clear all

t0  = 0;     %initial time
t1  = 100;    % final time
x0  = 3;     % initial cell population
y0  = 10;    % initial yeast concentration
%
% initial state for use in DE solver.
%
S0  = [x0;y0];

%
% rate constants and problem parameters
%

ep  = 14.3;
u   = 25;
v   = 5;
q   = 0.03;
fp   = 64.64;
yInf = 0.054;
K   = 30;
r   = q+K /yInf;

%
% rate constants into parameter vector
%
params(1) = q;
params(2) = u;
params(3) = r;
params(4) = K;
params(5) = ep;
%
% define function for fixed parameter values
%
chemostat_dynamics_params = @(t,S)chemostat_dynamics(t,S,params);

%
% call the matlab function to solve the DE for us.
%
[t,St] = ode45(chemostat_dynamics_params,[t0 t1],S0);
%
% Plot the results.
%
plot(t,St,'LineWidth',3)

legend('biomass','glucose')
xlabel('time, hours')
ylabel('states, grams')
